<?php
// settings.php v1.0
// Betatester.it - Settings

require_once __DIR__ . '/auth.php';
requireAuth();

$db = getDB();
$message = '';
$messageType = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'update_settings') {
        $settings = [
            'site_name' => trim($_POST['site_name'] ?? ''),
            'api_timeout' => (int) ($_POST['api_timeout'] ?? 120),
            'max_concurrent_requests' => (int) ($_POST['max_concurrent_requests'] ?? 3)
        ];
        
        foreach ($settings as $key => $value) {
            setSetting($key, (string) $value);
        }
        
        $message = 'Settings updated successfully';
        $messageType = 'success';
    }
    
    if ($action === 'change_password') {
        $currentPassword = $_POST['current_password'] ?? '';
        $newPassword = $_POST['new_password'] ?? '';
        $confirmPassword = $_POST['confirm_password'] ?? '';
        
        if ($newPassword !== $confirmPassword) {
            $message = 'New passwords do not match';
            $messageType = 'error';
        } else {
            $result = changePassword($_SESSION['user_id'], $currentPassword, $newPassword);
            $message = $result['message'];
            $messageType = $result['success'] ? 'success' : 'error';
        }
    }
}

// Get current settings
$settings = [
    'site_name' => getSetting('site_name', 'Betatester.it'),
    'api_timeout' => getSetting('api_timeout', '120'),
    'max_concurrent_requests' => getSetting('max_concurrent_requests', '3')
];

$user = getCurrentUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Settings - <?= h(SITE_NAME) ?> Admin</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
    <div class="admin-layout">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1>🤖 Betatester</h1>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-nav">
                <a href="index.php">📊 Dashboard</a>
                <a href="new-challenge.php">🚀 New Challenge</a>
                <a href="challenges.php">📋 All Challenges</a>
                <a href="ai-models.php">🤖 AI Models</a>
                <a href="settings.php" class="active">⚙️ Settings</a>
                <a href="logout.php" class="logout">🚪 Logout</a>
            </nav>
        </aside>
        
        <main class="main-content">
            <header class="page-header">
                <h2>⚙️ Settings</h2>
            </header>
            
            <?php if ($message): ?>
            <div class="alert alert-<?= $messageType ?>"><?= h($message) ?></div>
            <?php endif; ?>
            
            <div class="content-grid">
                <div class="card">
                    <h3>General Settings</h3>
                    <form method="POST">
                        <input type="hidden" name="action" value="update_settings">
                        
                        <div class="form-group">
                            <label>Site Name</label>
                            <input type="text" name="site_name" value="<?= h($settings['site_name']) ?>">
                        </div>
                        
                        <div class="form-group">
                            <label>API Timeout (seconds)</label>
                            <input type="number" name="api_timeout" value="<?= h($settings['api_timeout']) ?>" min="30" max="300">
                            <div class="help-text">How long to wait for AI API responses</div>
                        </div>
                        
                        <div class="form-group">
                            <label>Max Concurrent Requests</label>
                            <input type="number" name="max_concurrent_requests" value="<?= h($settings['max_concurrent_requests']) ?>" min="1" max="10">
                            <div class="help-text">Number of AI APIs to call simultaneously</div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Save Settings</button>
                    </form>
                </div>
                
                <div class="card">
                    <h3>Change Password</h3>
                    <form method="POST">
                        <input type="hidden" name="action" value="change_password">
                        
                        <div class="form-group">
                            <label>Current Password</label>
                            <input type="password" name="current_password" required>
                        </div>
                        
                        <div class="form-group">
                            <label>New Password</label>
                            <input type="password" name="new_password" required minlength="8">
                        </div>
                        
                        <div class="form-group">
                            <label>Confirm New Password</label>
                            <input type="password" name="confirm_password" required minlength="8">
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Change Password</button>
                    </form>
                </div>
            </div>
            
            <div class="card">
                <h3>Account Info</h3>
                <p><strong>Username:</strong> <?= h($user['username']) ?></p>
                <p><strong>Email:</strong> <?= h($user['email'] ?? 'Not set') ?></p>
                <p><strong>Last Login:</strong> <?= $user['last_login'] ? date('M j, Y H:i', strtotime($user['last_login'])) : 'N/A' ?></p>
            </div>
        </main>
    </div>
</body>
</html>
