<?php
// index.php v1.0
// Betatester.it - Admin Dashboard

require_once __DIR__ . '/auth.php';
requireAuth();

$db = getDB();

// Get stats
$stats = [
    'total_challenges' => $db->query('SELECT COUNT(*) FROM challenges')->fetchColumn(),
    'completed' => $db->query("SELECT COUNT(*) FROM challenges WHERE status = 'completed'")->fetchColumn(),
    'total_votes' => $db->query('SELECT COUNT(*) FROM votes')->fetchColumn(),
    'active_models' => $db->query('SELECT COUNT(*) FROM ai_models WHERE is_active = 1')->fetchColumn()
];

// Get recent challenges
$recentChallenges = $db->query('
    SELECT c.*, 
           (SELECT COUNT(*) FROM challenge_outputs WHERE challenge_id = c.id) as output_count
    FROM challenges c 
    ORDER BY created_at DESC 
    LIMIT 10
')->fetchAll();

// Get leaderboard
$leaderboard = $db->query('
    SELECT am.name, am.color_hex, r.*
    FROM rankings r
    JOIN ai_models am ON am.id = r.ai_model_id
    WHERE am.is_active = 1
    ORDER BY r.avg_total_score DESC
')->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Dashboard - <?= h(SITE_NAME) ?> Admin</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
    <div class="admin-layout">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1>🤖 Betatester</h1>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-nav">
                <a href="index.php" class="active">📊 Dashboard</a>
                <a href="new-challenge.php">🚀 New Challenge</a>
                <a href="challenges.php">📋 All Challenges</a>
                <a href="ai-models.php">🤖 AI Models</a>
                <a href="settings.php">⚙️ Settings</a>
                <a href="logout.php" class="logout">🚪 Logout</a>
            </nav>
        </aside>
        
        <main class="main-content">
            <header class="page-header">
                <h2>Dashboard</h2>
                <a href="new-challenge.php" class="btn btn-primary">+ New Challenge</a>
            </header>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-value"><?= $stats['total_challenges'] ?></div>
                    <div class="stat-label">Total Challenges</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?= $stats['completed'] ?></div>
                    <div class="stat-label">Completed</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?= $stats['total_votes'] ?></div>
                    <div class="stat-label">AI Votes Cast</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?= $stats['active_models'] ?></div>
                    <div class="stat-label">Active Models</div>
                </div>
            </div>
            
            <div class="content-grid">
                <section class="card">
                    <h3>🏆 Leaderboard</h3>
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>AI Model</th>
                                <th>Score</th>
                                <th>Wins</th>
                                <th>Challenges</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($leaderboard as $i => $ai): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td>
                                    <span class="color-dot" style="background: <?= h($ai['color_hex']) ?>"></span>
                                    <?= h($ai['name']) ?>
                                </td>
                                <td><strong><?= number_format($ai['avg_total_score'], 2) ?></strong></td>
                                <td><?= $ai['total_wins'] ?></td>
                                <td><?= $ai['total_challenges'] ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($leaderboard)): ?>
                            <tr><td colspan="5" class="empty">No data yet. Create your first challenge!</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </section>
                
                <section class="card">
                    <h3>📋 Recent Challenges</h3>
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>Challenge</th>
                                <th>Status</th>
                                <th>AIs</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentChallenges as $ch): ?>
                            <tr>
                                <td>
                                    <a href="challenge-detail.php?id=<?= $ch['id'] ?>">
                                        <?= h(substr($ch['prompt_text'], 0, 50)) ?><?= strlen($ch['prompt_text']) > 50 ? '...' : '' ?>
                                    </a>
                                </td>
                                <td><span class="status status-<?= $ch['status'] ?>"><?= $ch['status'] ?></span></td>
                                <td><?= $ch['output_count'] ?></td>
                                <td><?= date('M j', strtotime($ch['created_at'])) ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($recentChallenges)): ?>
                            <tr><td colspan="4" class="empty">No challenges yet</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </section>
            </div>
        </main>
    </div>
</body>
</html>
