<?php
// challenges.php v1.0
// Betatester.it - All Challenges List

require_once __DIR__ . '/auth.php';
requireAuth();

$db = getDB();

// Get filter
$status = $_GET['status'] ?? '';

// Build query
$sql = 'SELECT c.*, 
        (SELECT COUNT(*) FROM challenge_outputs WHERE challenge_id = c.id) as output_count,
        (SELECT COUNT(*) FROM votes WHERE challenge_id = c.id) as vote_count
        FROM challenges c';
$params = [];

if ($status) {
    $sql .= ' WHERE c.status = ?';
    $params[] = $status;
}

$sql .= ' ORDER BY c.created_at DESC';

$stmt = $db->prepare($sql);
$stmt->execute($params);
$challenges = $stmt->fetchAll();

// Get status counts
$statusCounts = $db->query("
    SELECT status, COUNT(*) as count 
    FROM challenges 
    GROUP BY status
")->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Challenges - <?= h(SITE_NAME) ?> Admin</title>
    <link rel="stylesheet" href="assets/admin.css">
    <style>
        .filters {
            display: flex;
            gap: 10px;
            margin-bottom: 24px;
        }
        .filter-btn {
            padding: 8px 16px;
            border-radius: 20px;
            border: 1px solid var(--border);
            background: var(--bg-input);
            color: var(--text-muted);
            text-decoration: none;
            font-size: 14px;
        }
        .filter-btn:hover { border-color: var(--primary); color: var(--text); }
        .filter-btn.active { background: var(--primary); border-color: var(--primary); color: var(--text); }
        .challenge-prompt {
            max-width: 400px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        .actions a {
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <div class="admin-layout">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1>🤖 Betatester</h1>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-nav">
                <a href="index.php">📊 Dashboard</a>
                <a href="new-challenge.php">🚀 New Challenge</a>
                <a href="challenges.php" class="active">📋 All Challenges</a>
                <a href="ai-models.php">🤖 AI Models</a>
                <a href="settings.php">⚙️ Settings</a>
                <a href="logout.php" class="logout">🚪 Logout</a>
            </nav>
        </aside>
        
        <main class="main-content">
            <header class="page-header">
                <h2>📋 All Challenges</h2>
                <a href="new-challenge.php" class="btn btn-primary">+ New Challenge</a>
            </header>
            
            <div class="filters">
                <a href="challenges.php" class="filter-btn <?= empty($status) ? 'active' : '' ?>">
                    All (<?= array_sum($statusCounts) ?>)
                </a>
                <a href="?status=completed" class="filter-btn <?= $status === 'completed' ? 'active' : '' ?>">
                    Completed (<?= $statusCounts['completed'] ?? 0 ?>)
                </a>
                <a href="?status=generating" class="filter-btn <?= $status === 'generating' ? 'active' : '' ?>">
                    Generating (<?= $statusCounts['generating'] ?? 0 ?>)
                </a>
                <a href="?status=voting" class="filter-btn <?= $status === 'voting' ? 'active' : '' ?>">
                    Voting (<?= $statusCounts['voting'] ?? 0 ?>)
                </a>
                <a href="?status=error" class="filter-btn <?= $status === 'error' ? 'active' : '' ?>">
                    Error (<?= $statusCounts['error'] ?? 0 ?>)
                </a>
            </div>
            
            <div class="card">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Prompt</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>AIs</th>
                            <th>Votes</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($challenges as $ch): ?>
                        <tr>
                            <td><?= $ch['id'] ?></td>
                            <td class="challenge-prompt" title="<?= h($ch['prompt_text']) ?>">
                                <?= h($ch['prompt_text']) ?>
                            </td>
                            <td><code><?= h($ch['slug']) ?></code></td>
                            <td><span class="status status-<?= $ch['status'] ?>"><?= $ch['status'] ?></span></td>
                            <td><?= $ch['output_count'] ?></td>
                            <td><?= $ch['vote_count'] ?></td>
                            <td><?= date('M j, Y H:i', strtotime($ch['created_at'])) ?></td>
                            <td class="actions">
                                <a href="challenge-detail.php?id=<?= $ch['id'] ?>">View</a>
                                <?php if ($ch['status'] === 'completed'): ?>
                                <a href="<?= CHALLENGES_URL ?>/<?= h($ch['slug']) ?>/" target="_blank">Preview</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($challenges)): ?>
                        <tr>
                            <td colspan="8" class="empty">No challenges found</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</body>
</html>
