<?php
// challenge-detail.php v1.0
// Betatester.it - Challenge Detail View

require_once __DIR__ . '/auth.php';
requireAuth();

$db = getDB();
$id = (int) ($_GET['id'] ?? 0);

if (!$id) {
    header('Location: challenges.php');
    exit;
}

// Get challenge
$stmt = $db->prepare('SELECT * FROM challenges WHERE id = ?');
$stmt->execute([$id]);
$challenge = $stmt->fetch();

if (!$challenge) {
    header('Location: challenges.php');
    exit;
}

// Get outputs with model info
$stmt = $db->prepare('
    SELECT co.*, am.name as model_name, am.color_hex, am.provider
    FROM challenge_outputs co
    JOIN ai_models am ON am.id = co.ai_model_id
    WHERE co.challenge_id = ?
    ORDER BY co.file_number ASC
');
$stmt->execute([$id]);
$outputs = $stmt->fetchAll();

// Get votes summary per output
$voteSummary = [];
foreach ($outputs as $output) {
    $stmt = $db->prepare('
        SELECT 
            AVG(functionality) as avg_func,
            AVG(aesthetics) as avg_aest,
            AVG(creativity) as avg_crea,
            AVG(code_quality) as avg_code,
            AVG(total_score) as avg_total,
            COUNT(*) as vote_count
        FROM votes 
        WHERE voted_output_id = ?
    ');
    $stmt->execute([$output['id']]);
    $voteSummary[$output['id']] = $stmt->fetch();
}

// Get individual votes
$stmt = $db->prepare('
    SELECT v.*, am.name as voter_name
    FROM votes v
    JOIN ai_models am ON am.id = v.voter_ai_id
    WHERE v.challenge_id = ?
    ORDER BY v.voted_output_id, v.voter_ai_id
');
$stmt->execute([$id]);
$allVotes = $stmt->fetchAll();

// Group votes by output
$votesByOutput = [];
foreach ($allVotes as $vote) {
    $votesByOutput[$vote['voted_output_id']][] = $vote;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Challenge #<?= $id ?> - <?= h(SITE_NAME) ?> Admin</title>
    <link rel="stylesheet" href="assets/admin.css">
    <style>
        .output-card {
            background: var(--bg-input);
            border: 1px solid var(--border);
            border-radius: 12px;
            margin-bottom: 20px;
            overflow: hidden;
        }
        .output-header {
            padding: 16px 20px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .output-body {
            padding: 20px;
        }
        .score-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 16px;
            margin-bottom: 20px;
        }
        .score-item {
            text-align: center;
            padding: 16px;
            background: var(--bg-card);
            border-radius: 8px;
        }
        .score-item .value {
            font-size: 24px;
            font-weight: 700;
            color: var(--primary);
        }
        .score-item .label {
            font-size: 12px;
            color: var(--text-muted);
            margin-top: 4px;
        }
        .votes-table {
            font-size: 14px;
        }
        .votes-table th {
            font-size: 12px;
        }
        .preview-frame {
            width: 100%;
            height: 400px;
            border: 1px solid var(--border);
            border-radius: 8px;
            margin-top: 16px;
        }
        .prompt-box {
            background: var(--bg-input);
            padding: 16px 20px;
            border-radius: 8px;
            margin-bottom: 24px;
            border-left: 4px solid var(--primary);
        }
        .winner-badge {
            background: var(--success);
            color: #fff;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="admin-layout">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1>🤖 Betatester</h1>
                <span>Admin Panel</span>
            </div>
            <nav class="sidebar-nav">
                <a href="index.php">📊 Dashboard</a>
                <a href="new-challenge.php">🚀 New Challenge</a>
                <a href="challenges.php">📋 All Challenges</a>
                <a href="ai-models.php">🤖 AI Models</a>
                <a href="settings.php">⚙️ Settings</a>
                <a href="logout.php" class="logout">🚪 Logout</a>
            </nav>
        </aside>
        
        <main class="main-content">
            <header class="page-header">
                <h2>Challenge #<?= $id ?></h2>
                <div>
                    <span class="status status-<?= $challenge['status'] ?>"><?= $challenge['status'] ?></span>
                    <?php if ($challenge['status'] === 'completed'): ?>
                    <a href="<?= CHALLENGES_URL ?>/<?= h($challenge['slug']) ?>/" class="btn btn-primary" target="_blank">View Public Page</a>
                    <?php endif; ?>
                </div>
            </header>
            
            <div class="prompt-box">
                <strong>Prompt:</strong> <?= h($challenge['prompt_text']) ?>
            </div>
            
            <div class="card" style="margin-bottom: 24px;">
                <p><strong>Slug:</strong> <code><?= h($challenge['slug']) ?></code></p>
                <p><strong>Created:</strong> <?= date('M j, Y H:i:s', strtotime($challenge['created_at'])) ?></p>
                <?php if ($challenge['completed_at']): ?>
                <p><strong>Completed:</strong> <?= date('M j, Y H:i:s', strtotime($challenge['completed_at'])) ?></p>
                <?php endif; ?>
            </div>
            
            <h3 style="margin-bottom: 16px;">AI Outputs & Scores</h3>
            
            <?php 
            // Find winner
            $maxScore = 0;
            $winnerId = null;
            foreach ($outputs as $o) {
                $score = $voteSummary[$o['id']]['avg_total'] ?? 0;
                if ($score > $maxScore) {
                    $maxScore = $score;
                    $winnerId = $o['id'];
                }
            }
            ?>
            
            <?php foreach ($outputs as $output): ?>
            <?php $votes = $voteSummary[$output['id']]; $isWinner = ($output['id'] == $winnerId); ?>
            <div class="output-card" style="<?= $isWinner ? 'border-color: var(--success);' : '' ?>">
                <div class="output-header">
                    <div>
                        <span class="color-dot" style="background: <?= h($output['color_hex']) ?>"></span>
                        <strong><?= h($output['model_name']) ?></strong>
                        <span style="color: var(--text-muted); margin-left: 10px;">
                            File: <?= $output['file_number'] ?>.html
                            | <?= number_format($output['generation_time_ms'] / 1000, 1) ?>s
                            | <?= number_format(strlen($output['output_html'] ?? '')) ?> bytes
                        </span>
                    </div>
                    <?php if ($isWinner): ?>
                    <span class="winner-badge">🏆 Winner</span>
                    <?php endif; ?>
                </div>
                <div class="output-body">
                    <div class="score-grid">
                        <div class="score-item">
                            <div class="value"><?= number_format($votes['avg_func'] ?? 0, 1) ?></div>
                            <div class="label">Functionality</div>
                        </div>
                        <div class="score-item">
                            <div class="value"><?= number_format($votes['avg_aest'] ?? 0, 1) ?></div>
                            <div class="label">Aesthetics</div>
                        </div>
                        <div class="score-item">
                            <div class="value"><?= number_format($votes['avg_crea'] ?? 0, 1) ?></div>
                            <div class="label">Creativity</div>
                        </div>
                        <div class="score-item">
                            <div class="value"><?= number_format($votes['avg_code'] ?? 0, 1) ?></div>
                            <div class="label">Code Quality</div>
                        </div>
                        <div class="score-item" style="background: var(--primary); color: #fff;">
                            <div class="value" style="color: #fff;"><?= number_format($votes['avg_total'] ?? 0, 2) ?></div>
                            <div class="label" style="color: rgba(255,255,255,0.8);">Total Score</div>
                        </div>
                    </div>
                    
                    <?php if (!empty($votesByOutput[$output['id']])): ?>
                    <details>
                        <summary style="cursor: pointer; margin-bottom: 12px;">View Individual Votes (<?= count($votesByOutput[$output['id']]) ?>)</summary>
                        <table class="data-table votes-table">
                            <thead>
                                <tr>
                                    <th>Voter</th>
                                    <th>Func</th>
                                    <th>Aest</th>
                                    <th>Crea</th>
                                    <th>Code</th>
                                    <th>Total</th>
                                    <th>Feedback</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($votesByOutput[$output['id']] as $vote): ?>
                                <tr>
                                    <td><?= h($vote['voter_name']) ?></td>
                                    <td><?= $vote['functionality'] ?></td>
                                    <td><?= $vote['aesthetics'] ?></td>
                                    <td><?= $vote['creativity'] ?></td>
                                    <td><?= $vote['code_quality'] ?></td>
                                    <td><strong><?= number_format($vote['total_score'], 2) ?></strong></td>
                                    <td><?= h($vote['feedback'] ?? '-') ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </details>
                    <?php endif; ?>
                    
                    <?php if ($challenge['status'] === 'completed' && $output['file_path']): ?>
                    <details>
                        <summary style="cursor: pointer; margin-top: 12px;">Preview Output</summary>
                        <iframe src="<?= CHALLENGES_URL . h($output['file_path']) ?>" class="preview-frame" sandbox="allow-scripts"></iframe>
                    </details>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </main>
    </div>
</body>
</html>
