<?php
// api/get-models.php v1.0
// Betatester.it - Get available AI models

require_once dirname(__DIR__) . '/auth.php';
require_once dirname(__DIR__) . '/AIService.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'error' => 'Unauthorized'], 401);
}

$ai = new AIService();
$models = $ai->getActiveModels(true);

// Remove sensitive data
$safeModels = array_map(function($model) {
    return [
        'id' => $model['id'],
        'name' => $model['name'],
        'provider' => $model['provider'],
        'color_hex' => $model['color_hex'],
        'can_generate' => (bool) $model['can_generate'],
        'can_vote' => (bool) $model['can_vote'],
        'has_api_key' => !empty($model['api_key'])
    ];
}, $models);

jsonResponse([
    'success' => true,
    'models' => $safeModels
]);
