<?php
// api/generate-slug.php v1.0
// Betatester.it - Generate SEO slug from prompt

require_once dirname(__DIR__) . '/auth.php';
require_once dirname(__DIR__) . '/AIService.php';

header('Content-Type: application/json');

// Check authentication
if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'error' => 'Unauthorized'], 401);
}

// Only POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'error' => 'Method not allowed'], 405);
}

// Get input
$input = json_decode(file_get_contents('php://input'), true);
$prompt = trim($input['prompt'] ?? '');

if (empty($prompt)) {
    jsonResponse(['success' => false, 'error' => 'Prompt is required']);
}

$ai = new AIService();
$result = $ai->generateSlug($prompt);

if (!$result['success']) {
    jsonResponse(['success' => false, 'error' => $result['error'] ?? 'Failed to generate slug']);
}

$slug = $result['slug'];
$db = getDB();

// Check if slug exists, append number if needed
$originalSlug = $slug;
$counter = 1;
while (true) {
    $stmt = $db->prepare('SELECT id FROM challenges WHERE slug = ?');
    $stmt->execute([$slug]);
    if (!$stmt->fetch()) {
        break;
    }
    $slug = $originalSlug . '-' . $counter;
    $counter++;
}

jsonResponse([
    'success' => true,
    'slug' => $slug
]);
