<?php
// api/create-challenge.php v1.0
// Betatester.it - Create new challenge and assign randomized file numbers

require_once dirname(__DIR__) . '/auth.php';
require_once dirname(__DIR__) . '/AIService.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'error' => 'Unauthorized'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'error' => 'Method not allowed'], 405);
}

$input = json_decode(file_get_contents('php://input'), true);
$prompt = trim($input['prompt'] ?? '');
$slug = trim($input['slug'] ?? '');
$modelIds = $input['model_ids'] ?? [];

if (empty($prompt)) {
    jsonResponse(['success' => false, 'error' => 'Prompt is required']);
}

if (empty($slug)) {
    jsonResponse(['success' => false, 'error' => 'Slug is required']);
}

if (empty($modelIds) || !is_array($modelIds)) {
    jsonResponse(['success' => false, 'error' => 'At least one AI model must be selected']);
}

$db = getDB();

try {
    $db->beginTransaction();
    
    // Create challenge
    $stmt = $db->prepare('INSERT INTO challenges (prompt_text, slug, status, created_at) VALUES (?, ?, ?, NOW())');
    $stmt->execute([$prompt, $slug, 'generating']);
    $challengeId = $db->lastInsertId();
    
    // Shuffle model IDs for random file assignment
    shuffle($modelIds);
    
    // Create output placeholders with randomized file numbers
    $stmt = $db->prepare('INSERT INTO challenge_outputs (challenge_id, ai_model_id, file_number, status) VALUES (?, ?, ?, ?)');
    
    $fileMapping = [];
    foreach ($modelIds as $index => $modelId) {
        $fileNumber = $index + 1;
        $stmt->execute([$challengeId, $modelId, $fileNumber, 'pending']);
        $fileMapping[] = [
            'output_id' => $db->lastInsertId(),
            'model_id' => (int) $modelId,
            'file_number' => $fileNumber
        ];
    }
    
    $db->commit();
    
    jsonResponse([
        'success' => true,
        'challenge_id' => (int) $challengeId,
        'slug' => $slug,
        'file_mapping' => $fileMapping
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    jsonResponse(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
}
