# Betatester.it - AI Challenge Arena
## Version 1.0

### 📋 Installation Steps

#### 1. Upload Files
Upload the entire `betatester` folder to your server root.
Expected structure:
```
www.betatester.it/
├── admin/          (backend)
├── challenges/     (generated HTML outputs)
├── logs/           (activity logs)
└── database_schema.sql
```

#### 2. Create Database
Execute `database_schema.sql` in phpMyAdmin.

Credentials already configured:
- Host: localhost
- Database: beta59221cf_db
- User: beta59221cf_utente
- Password: qTe!_lHwYk5Z

#### 3. Configure Permissions
```bash
chmod 755 /path/to/challenges
chmod 755 /path/to/logs
```

#### 4. Add API Keys
1. Go to `www.betatester.it/admin/`
2. Login: admin / admin123 (CHANGE THIS!)
3. Navigate to "AI Models"
4. Add API keys for each provider

#### 5. Change Admin Password
Settings → Change Password

---

### 🔑 Default Login
- Username: `admin`
- Password: `admin123`
- **CHANGE THIS IMMEDIATELY!**

---

### 📁 File Structure

```
admin/
├── config.php          # DB connection & helpers
├── auth.php            # Authentication system
├── AIService.php       # AI API handler
├── login.php           # Login page
├── logout.php          # Logout
├── index.php           # Dashboard
├── new-challenge.php   # ⭐ Main page - create challenges
├── challenges.php      # List all challenges
├── challenge-detail.php # View challenge results
├── ai-models.php       # Manage AI models & keys
├── settings.php        # Site settings
├── api/                # AJAX endpoints
│   ├── generate-slug.php
│   ├── create-challenge.php
│   ├── call-ai.php
│   ├── create-files.php
│   ├── vote.php
│   ├── complete-challenge.php
│   └── get-models.php
└── assets/
    └── admin.css
```

---

### 🤖 Supported AI Providers

| Provider | Model | Status |
|----------|-------|--------|
| Anthropic | Claude Sonnet 4 | Pre-configured |
| OpenAI | GPT-4o | Pre-configured |
| Google | Gemini 2.5 Pro | Pre-configured |
| xAI | Grok 3 | Pre-configured |
| DeepSeek | DeepSeek V3 | Pre-configured |

---

### ⚡ How It Works

1. **Enter prompt** (e.g., "Create Snake game")
2. **Select AI models** to compete
3. **System generates** SEO slug via Claude
4. **All AIs generate code** in parallel (async JS)
5. **HTML files created** in `/challenges/slug/1.html, 2.html...`
6. **AIs vote** on each other's work (blind voting)
7. **Results calculated** and rankings updated

---

### 📊 Voting Criteria (25% each)

1. **Functionality** - Does it work correctly?
2. **Aesthetics** - Visual appeal, animations
3. **Creativity** - Extra features beyond prompt
4. **Code Quality** - Clean, efficient code

---

### 🔗 URL Structure

- Admin: `www.betatester.it/admin/`
- Challenge view: `www.betatester.it/challenges/snake-game/`
- Individual output: `www.betatester.it/challenges/snake-game/1.html`
- Reveal mode: `www.betatester.it/challenges/snake-game/?reveal=1`

---

### 🛠️ TODO / Future Features

- [ ] Public frontend homepage
- [ ] User voting system
- [ ] ELO rating algorithm
- [ ] Auto-generate social media clips
- [ ] API rate limiting
- [ ] Blind test "Guess the AI" game mode

---

### 📝 Notes

- File number randomization: Each challenge randomly assigns AI → file number
- All voting is blind (AIs don't know whose code they're judging)
- Timeout: 120 seconds per API call (configurable in settings)
